#include "substitution.h"
#include <algorithm> /* find, swap */

	
namespace lp {


	void Subst::print(ostream& os) const
	{
		os << "{ ";
		const_iterator i = subs.begin();
		if (i != subs.end()) {
			Functor::print_id(os,i->first);
			os << "/" << *i->second.first;
			++i;
			for ( ; i != subs.end(); ++i) {
				os << ", ";
				Functor::print_id(os,i->first);
				os << "/" << *i->second.first;
			}
		}
		os << " }";
	}


	bool Subst::operator==(const Subst& s) const 
	{
		// require same size first
		if (subs.size() != s.subs.size()) return false;
		for (auto i = subs.begin(); i != subs.end(); ++i) {
			auto at = s.subs.find(i->first);
			if (at == s.subs.end()) return false;
			// Compare functors (ignore allocation type)
			if (*i->second.first != *at->second.first) return false;
		}
		// x in T => x in S, but no duplicates are possible and size(T)=size(S), T=S
		return true;
	}
	
	
	Functor* Subst::expand(const Functor* f) const
	{
		if (f->is_variable()) {
			//return expand_var(f);
			const_iterator i = subs.find(f->id());
			if (i == subs.end()) {
				return new Functor(f->id()); // no substitution
			} else {
				return expand(i->second.first); // follow substitution
			}
		}
		// Create copy
		Functor* subtree = new Functor(f->id());
		for_each(f->arg_begin(),f->arg_end(),[&](const Functor* c){subtree->steal(this->expand(c));});
		return subtree;
	}

}

